/*
 * Decompiled with CFR 0.152.
 */
package com.itayfeder.nock_enough_arrows.quiver;

import java.util.List;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class QuiverItemStackHandler
extends ItemStackHandler {
    public static final int NUMBER_SLOTS = 5;

    public QuiverItemStackHandler() {
        super(5);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        if (slot >= 0 && slot < this.getSlots()) {
            if (stack.m_41619_()) {
                return false;
            }
            return stack.m_41720_() instanceof ArrowItem;
        }
        throw new IllegalArgumentException("Invalid slot number: " + slot);
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    public List<ItemStack> getItems() {
        return this.stacks.stream().toList();
    }

    public int getFilledStacks() {
        int count = 0;
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.isAir(i)) continue;
            ++count;
        }
        return count;
    }

    public ItemStack addStack(ItemStack stack) {
        ItemStack addedStack = stack.m_41777_();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if ((addedStack = this.insertItem(i, addedStack, false)) != ItemStack.f_41583_) continue;
            i = this.stacks.size();
        }
        return addedStack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack extracted = super.extractItem(slot, amount, simulate);
        return extracted;
    }

    public int getFirstFilledSlot() {
        if (this.isAllAir()) {
            return 0;
        }
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.isAir(i)) continue;
            return i;
        }
        return 0;
    }

    public boolean isAllAir() {
        for (ItemStack stack : this.getItems()) {
            if (stack.m_41720_() == Items.f_41852_) continue;
            return false;
        }
        return true;
    }

    public boolean isAir(int slot) {
        return this.getItems().get(slot).m_41720_() == Items.f_41852_;
    }
}

